function [commLabels links]= linkCommunities(A,nodeLabels,pToUse)
%LINKCOMMUNITIES Find link communities of a graph
%   Uses a method adapted from Ahn, Bagrow, Lehmann, Link communities
%   reveal multiscale complexity in networks, Nature June 2010
%
%   A should be a square adjacency matrix
%   [commLabels link] = linkCommunities(A) will return a vector of
%   community labels (numbers), and the corresponding links (which will be
%   an N x 2 matrix, where N is the number of links in A - each link is a
%   directed pair of nodes

% Form similarity matrix for edges

% Consider in and out edges when computing Tanimoto similarity between
% nodes

useMaxP = ~logical(pToUse);

% Clear self loops
A(logical(eye(size(A)))) = 0;

in = 1; out = 1;

S = tanimotoSim(A,in,out);

[ii jj] = find(A);
links = [ii jj];
javaaddpath('C:\Users\Scott\Desktop\Adam\NetBeans Projects\LinkCommunitiesHelper\build\classes');

linkSimMat = LinkCommunitiesHelper.LinkCommunitiesHelper.fillLinkSimilaritiesMatrix(links,S);


% linkSimMat
% links

% Now form the dendrogram
distMat = squareform(1 - linkSimMat);
L = linkage(distMat,'single');

% Now partition the dendrogram at every possible level
pmin = min(distMat);
pmax = max(distMat);

% Test values at .01 resolution
step = .01;
Dmat = zeros(numel(pmin:step:pmax),2);
i=1;
N = size(links,1);
vals = sort(unique(L(:,3)));
% vals
tPartition = 0;
tPartitionDensity = 0;

%Form dictionary for memoization of branch descendents
leavesDict = {};
leavesDict{N-1} = [];  %Pre-allocate size of leavesDict
%Pre-assign groupLabels
groupLabels = zeros(N,1);

if useMaxP
    pprev = 0;
    for i = 1:numel(vals)
        p = vals(i);
        %     fprintf('%.5f\n',p);
%         tic
        [groupLabels leavesDict] = partitionDendrogram(L,p,leavesDict,pprev,groupLabels);
%         tPartition = tPartition + toc;       
        %     groupLabels        
%         tic
        Dmat(i,:) = [p partitionDensity];
%         tPartitionDensity = tPartitionDensity + toc;
        pprev = p;
        %     groupLabels
    end
    
    % For timing computational efficiency
    % fprintf('Partition: %.3f\t\tPartitionDensity:% %3f\n',tPartition,tPartitionDensity);
      
    [val idx] = max(Dmat(:,2));
    
    pToUse = Dmat(idx,1)
end

    function D = partitionDensity
        D = 0;
        for g = 1:max(groupLabels)
            mc = sum(groupLabels==g);
            linksIng= links(groupLabels==g,:);
            nc = numel(unique(linksIng(:)));
            if nc == 2
                Dc = 0;
            else
                Dc = mc*(mc-(nc-1))./((nc-2)*(nc-1));
                D = D+Dc;
            end
            
        end
        D = D*2/N;
    end

%Pre-assign groupLabels
groupLabels = zeros(N,1);
%Find labels for maximal value of D
commLabels = partitionDendrogram(L,pToUse,leavesDict,0,groupLabels);

scatter(Dmat(:,1)',Dmat(:,2)','ro');


labels = {};
for i = 1:size(links,1)
    labels{i} = sprintf('(%s,%s)',nodeLabels{links(i,1)},nodeLabels{links(i,2)});
end
%Show dendrogram  WARNING: this can be slow if there are a lot of edges
% figure;
% dendrogram(L,0,'labels',labels);

% nodeGroups = {};
% nodeGroups{max(commLabels)} = [];
% 
% for i = 1:size(links,1)
%     if commLabels(i) ~= 0
%         nodeGroups{commLabels(i)} = union(nodeGroups{commLabels(i)},links(i,:));
%     end
% end

javarmpath('C:\Users\Scott\Desktop\Adam\NetBeans Projects\LinkCommunitiesHelper\build\classes');

end

